/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.gui.custom.components.CustomGuiButton;
import noppes.npcs.client.gui.custom.components.CustomGuiEntity;
import noppes.npcs.client.gui.custom.components.CustomGuiLabel;
import noppes.npcs.client.gui.custom.components.CustomGuiScrollComponent;
import noppes.npcs.client.gui.custom.components.CustomGuiTextField;
import noppes.npcs.client.gui.custom.components.CustomGuiTexturedRect;
import noppes.npcs.client.gui.custom.interfaces.IClickListener;
import noppes.npcs.client.gui.custom.interfaces.ICustomKeyListener;
import noppes.npcs.client.gui.custom.interfaces.IDataHolder;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerCustomGui;
import org.lwjgl.input.Mouse;

public class GuiCustom
extends GuiContainer
implements ICustomScrollListener,
IGuiData {
    public static int guiLeft;
    public static int guiTop;
    public int mouseWheel;
    ResourceLocation background;
    Map<Integer, IGuiComponent> components = new HashMap<Integer, IGuiComponent>();
    CustomGuiWrapper gui;
    List<IClickListener> clickListeners = new ArrayList<IClickListener>();
    List<ICustomKeyListener> keyListeners = new ArrayList<ICustomKeyListener>();
    List<IDataHolder> dataHolders = new ArrayList<IDataHolder>();
    protected int field_146999_f;
    protected int field_147000_g;
    private int stretched = 0;
    private int bgW = 0;
    private int bgH = 0;
    private int bgTx = 256;
    private int bgTy = 256;
    public String[] hoverText;
    public ItemStack hoverStack;

    public GuiCustom(ContainerCustomGui container) {
        super((Container)container);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiButton, this.updateGui().toNBT(), button.field_146127_k);
    }

    public void addClickListener(IClickListener component) {
        this.clickListeners.add(component);
    }

    private void addComponent(ICustomGuiComponent component) {
        CustomGuiComponentWrapper c = (CustomGuiComponentWrapper)component;
        switch (c.getType()) {
            case 0: {
                CustomGuiButton button = CustomGuiButton.fromComponent((CustomGuiButtonWrapper)component);
                button.setParent(this);
                this.components.put(button.getId(), button);
                this.addClickListener(button);
                break;
            }
            case 1: {
                CustomGuiLabel lbl = CustomGuiLabel.fromComponent((CustomGuiLabelWrapper)component);
                lbl.setParent(this);
                this.components.put(lbl.getId(), lbl);
                break;
            }
            case 3: {
                CustomGuiTextField textField = CustomGuiTextField.fromComponent((CustomGuiTextFieldWrapper)component);
                textField.setParent(this);
                this.components.put(textField.field_175208_g, textField);
                this.addDataHolder(textField);
                this.addClickListener(textField);
                this.addKeyListener(textField);
                break;
            }
            case 2: {
                CustomGuiTexturedRect rect = CustomGuiTexturedRect.fromComponent((CustomGuiTexturedRectWrapper)component);
                rect.setParent(this);
                this.components.put(rect.getId(), rect);
                break;
            }
            case 4: {
                CustomGuiScrollComponent scroll = new CustomGuiScrollComponent(this.field_146297_k, this, component.getId(), (CustomGuiScrollWrapper)component);
                scroll.fromComponent((CustomGuiScrollWrapper)component);
                scroll.setParent(this);
                this.components.put(scroll.getId(), scroll);
                this.addDataHolder(scroll);
                this.addClickListener(scroll);
                break;
            }
            case 7: {
                CustomGuiEntity entt = CustomGuiEntity.fromComponent((CustomGuiEntityWrapper)component);
                entt.setParent(this);
                this.components.put(entt.getId(), entt);
                break;
            }
        }
    }

    public void addDataHolder(IDataHolder component) {
        this.dataHolders.add(component);
    }

    public void addKeyListener(ICustomKeyListener component) {
        this.keyListeners.add(component);
    }

    public void buttonClick(CustomGuiButton button) {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiButton, this.updateGui().toNBT(), button.field_146127_k);
    }

    public boolean func_73868_f() {
        return this.gui == null || this.gui.getDoesPauseGame();
    }

    void drawBackgroundTexture() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        if (this.bgW > 0 && this.bgH > 0) {
            if (this.stretched == 0) {
                float scaleU = (float)this.field_146999_f / (float)this.bgW;
                float scaleV = (float)this.field_147000_g / (float)this.bgH;
                GlStateManager.func_179152_a((float)scaleU, (float)scaleV, (float)1.0f);
                this.func_73729_b(0, 0, this.bgTx, this.bgTy, this.bgW, this.bgH);
            } else {
                int stepH;
                int hS = this.field_147000_g;
                int h = 0;
                int stepW = this.stretched == 2 ? this.field_146999_f / (int)Math.ceil((double)this.field_146999_f / (double)this.bgW) : this.bgW;
                int n = stepH = this.stretched == 2 ? this.field_147000_g / (int)Math.ceil((double)this.field_147000_g / (double)this.bgH) : this.bgH;
                if (this.stretched == 2) {
                    if (stepW >= this.field_146999_f) {
                        stepW = this.field_146999_f / 2;
                    }
                    if (stepH >= this.field_147000_g) {
                        stepH = this.field_147000_g / 2;
                    }
                }
                while (hS > 0) {
                    int height = Math.min(hS, stepH);
                    int startV = h * stepH;
                    int textureV = this.bgTy;
                    if (this.stretched == 2) {
                        if (hS <= stepH) {
                            if (h == 0) {
                                height = this.field_147000_g / 2;
                                hS = height + stepH;
                            } else {
                                startV = this.field_147000_g - height;
                                textureV += this.bgH - hS;
                                height = stepH;
                            }
                        } else if (h != 0 && stepH != this.bgW) {
                            textureV += (this.bgH - stepH) / 2;
                        }
                    }
                    int wS = this.field_146999_f;
                    int w = 0;
                    while (wS > 0) {
                        int width = Math.min(wS, stepW);
                        int startU = w * stepW;
                        int textureU = this.bgTx;
                        if (this.stretched == 2) {
                            if (wS <= stepW) {
                                if (w == 0) {
                                    width = this.field_146999_f / 2;
                                    wS = width + stepW;
                                } else {
                                    textureU += this.bgW - wS;
                                    width = stepW;
                                }
                            } else if (w != 0 && stepW != this.bgW) {
                                textureU += (this.bgW - stepW) / 2;
                            }
                        }
                        this.func_73729_b(startU, startV, textureU, textureV, width, height);
                        wS -= stepW;
                        ++w;
                    }
                    hS -= stepH;
                    ++h;
                }
            }
        } else {
            this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        GlStateManager.func_179121_F();
        if (this.gui.getShowPlayerSlots() && this.field_147002_h != null) {
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            int slotId = this.field_147002_h.field_75151_b.size() - 1;
            for (int i = 0; i < 36; ++i) {
                Slot slot = this.field_147002_h.func_75139_a(slotId);
                this.func_73729_b(this.getGuiLeft() + slot.field_75223_e - 1, this.getGuiTop() + slot.field_75221_f - 1, 0, 0, 18, 18);
                --slotId;
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseWheel = Mouse.getDWheel();
        this.hoverText = null;
        this.hoverStack = null;
        this.func_146276_q_();
        if (this.background != null) {
            this.drawBackgroundTexture();
        }
        for (IGuiComponent component : this.components.values()) {
            component.onRender(this.field_146297_k, mouseX, mouseY, this.mouseWheel, partialTicks);
        }
        if (this.gui != null && this.gui.getSlots().length > 0) {
            int cx = -41 + (256 - this.gui.getWidth()) / 2;
            int cy = -46 + (256 - this.gui.getHeight()) / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            for (IItemSlot slot : this.gui.getSlots()) {
                if (!slot.isShowBack()) continue;
                this.func_73729_b(this.getGuiLeft() + slot.getPosX() + cx, this.getGuiTop() + slot.getPosY() + cy, 0, 0, 18, 18);
            }
            GlStateManager.func_179121_F();
        }
        if (this.hoverStack != null) {
            this.func_146283_a(this.hoverStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), mouseX, mouseY);
        } else if (this.hoverText != null) {
            this.func_146283_a(Arrays.asList(this.hoverText), mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    NBTTagCompound getScrollSelection(CustomGuiScrollComponent scroll) {
        NBTTagList list = new NBTTagList();
        if (scroll.component.isMultiSelect()) {
            for (String s : scroll.getSelectedList()) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
        } else {
            list.func_74742_a((NBTBase)new NBTTagString(scroll.getSelected()));
        }
        NBTTagCompound selection = new NBTTagCompound();
        selection.func_74782_a("selection", (NBTBase)list);
        return selection;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.gui != null) {
            guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
            guiTop = (this.field_146295_m - this.field_147000_g) / 2;
            this.components.clear();
            this.clickListeners.clear();
            this.keyListeners.clear();
            this.dataHolders.clear();
            for (ICustomGuiComponent c : this.gui.getComponents()) {
                this.addComponent(c);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiKeyPressed, keyCode);
        for (ICustomKeyListener listener : this.keyListeners) {
            listener.keyTyped(typedChar, keyCode);
        }
        if (keyCode == 1 && this.gui != null) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiClose, this.updateGui().toNBT());
            return;
        }
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IClickListener listener : this.clickListeners) {
            listener.mouseClicked(this, mouseX, mouseY, mouseButton);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiScrollClick, this.updateGui().toNBT(), scroll.getID(), scroll.getSelect(), this.getScrollSelection((CustomGuiScrollComponent)scroll), false);
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CustomGuiScrollClick, this.updateGui().toNBT(), scroll.getID(), scroll.getSelect(), this.getScrollSelection((CustomGuiScrollComponent)scroll), true);
    }

    @Override
    public boolean hasSubGui() {
        return false;
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        Minecraft mc = Minecraft.func_71410_x();
        CustomGuiWrapper gui = (CustomGuiWrapper)new CustomGuiWrapper((EntityPlayer)mc.field_71439_g).fromNBT(compound);
        ((ContainerCustomGui)this.field_147002_h).setGui(gui, (EntityPlayer)mc.field_71439_g);
        this.gui = gui;
        this.field_146999_f = gui.getWidth();
        this.field_147000_g = gui.getHeight();
        if (!gui.getBackgroundTexture().isEmpty()) {
            this.background = new ResourceLocation(gui.getBackgroundTexture());
            this.stretched = gui.stretched;
            this.bgW = gui.bgW;
            this.bgH = gui.bgH;
            this.bgTx = gui.bgTx;
            this.bgTy = gui.bgTy;
        } else {
            this.stretched = 0;
            this.bgW = 0;
            this.bgH = 0;
            this.bgTx = 256;
            this.bgTy = 256;
        }
        this.func_73866_w_();
    }

    CustomGuiWrapper updateGui() {
        for (IDataHolder component : this.dataHolders) {
            this.gui.updateComponent(component.toComponent());
        }
        return this.gui;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IDataHolder component : this.dataHolders) {
            if (!(component instanceof GuiTextField)) continue;
            ((GuiTextField)component).func_146178_a();
        }
    }
}

